 

<!DOCTYPE html> 
<html>
  <head>
    <meta charset="UTF-8" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />

    <link href="https://fonts.googleapis.com/css2?family=Cousine:ital,wght@0,400;0,700;1,400;1,700&display=swap" rel="stylesheet" />

    <title>Glamorixlots - Déballez le luxe et la joie au quotidien avec  Glamorixlots  Beauté</title>

    <meta property="og:title" content="Glamorixlots - Déballez le luxe et la joie au quotidien avec  Glamorixlots  Beauté" />
    <meta property="og:image" content="service-images/reality-beauty-cosmetics-2025-10-09-1.jpg" />
    
    <meta property="og:description" content="À Glamorixlots , nous pensons que la beauté doit être plus quune routine : elle doit être un rituel,..." />
    <meta name="description" content="À Glamorixlots , nous pensons que la beauté doit être plus quune routine : elle doit être un rituel,..." />

    <link rel="stylesheet" href="interface/css/slick.css" />
    <link rel="stylesheet" href="interface/css/slick-theme.css" />
    <link rel="stylesheet" href="interface/css/bootstrap.min.css" />
    
    <script src="interface/js/bootstrap.min.js"></script>
    <script src="interface/js/jquery-3.7.1.min.js"></script>
    <script src="interface/js/slick.min.js"></script>

     
    <link rel="shortcut icon" href="logo-black.png" type="image/x-icon" />
    <link href="https://fonts.googleapis.com/css2?family=Cousine:ital,wght@0,400;0,700;1,400;1,700&display=swap" rel="stylesheet" />
    <link href="https://fonts.googleapis.com/css2?family=Caveat:wght@400;500;600;700&display=swap" rel="stylesheet" />

    <style>

      body {
          width: 100%;
          direction: ltr;
          font-family: 'Cousine', sans-serif !important;
          font-size: 17px;
          margin: 0;
          padding: 0;
          overflow-x: hidden;
      }

      :root {
        --m-col-1: #f17fc6;
        --m-col-2: #aa68ec;
        --m-col-3: #4dfb85;
        --m-col-4: #fa8893;
        --m-col-5: #9771f9;
      }

      h2 {
        text-align: center;
        width: 100%;
        font-size: 30px;
        font-weight: 400;
      }
      .main-For-pad {
        padding: 112px 0px;
      }
      .content-block p{
        margin-bottom: 12px;
        text-indent: 3ch;
      }
      .content-block h2{
          font-weight: 400;
          text-align: center;
          margin-bottom:  26px;
      }
 
      .content-block table, .content-block a{
          word-break: break-word;
          color: inherit;
      }

      .btn-1 {
        text-decoration: none;
        display: inline-block;
        transition: all 0.2s ease-in;
        position: relative;
        overflow: hidden;
        z-index: 1;
        color: #090909;
        padding: 0.7em 1.7em;
        cursor: pointer;
        font-size: 18px;
        border-radius: 0.5em;
        background: #e8e8e8;
        border: 1px solid #e8e8e8;
        box-shadow: 6px 6px 12px #c5c5c5, -6px -6px 12px #ffffff;
      }

      .btn-1:active {
        color: #666;
        box-shadow: inset 4px 4px 12px #c5c5c5, inset -4px -4px 12px #ffffff;
      }

      .btn-1:before {
        content: "";
        position: absolute;
        left: 50%;
        transform: translateX(-50%) scaleY(1) scaleX(1.25);
        top: 100%;
        width: 140%;
        height: 180%;
        background-color: rgba(0, 0, 0, 0.05);
        border-radius: 50%;
        display: block;
        transition: all 0.5s 0.1s cubic-bezier(0.55, 0, 0.1, 1);
        z-index: -1;
      }

      .btn-1:after {
        content: "";
        position: absolute;
        left: 55%;
        transform: translateX(-50%) scaleY(1) scaleX(1.45);
        top: 180%;
        width: 160%;
        height: 190%;
        background-color: var(--m-col-5);
        border-radius: 50%;
        display: block;
        transition: all 0.5s 0.1s cubic-bezier(0.55, 0, 0.1, 1);
        z-index: -1;
      }

      .btn-1:hover {
        color: #ffffff;
        border: 1px solid var(--m-col-5);
      }

      .btn-1:hover:before {
        top: -35%;
        background-color: var(--m-col-5);
        transform: translateX(-50%) scaleY(1.3) scaleX(0.8);
      }

      .btn-1:hover:after {
        top: -45%;
        background-color: var(--m-col-5);
        transform: translateX(-50%) scaleY(1.3) scaleX(0.8);
      }

      .btn-2 {
        display: inline-block;
        width: auto;
        text-decoration: none;
        position: relative;
        padding: 16px 20px;
        border-radius: 7px;
        border: 1px solid var(--m-col-5);
        font-size: 14px;
        text-transform: uppercase;
        font-weight: 400;
        letter-spacing: 2px;
        background: transparent;
        color: #fff;
        overflow: hidden;
        box-shadow: 0 0 0 0 transparent;
        -webkit-transition: all 0.2s ease-in;
        -moz-transition: all 0.2s ease-in;
        transition: all 0.2s ease-in;
      }

      .btn-2:hover {
        color: white;
        background: var(--m-col-5);
        box-shadow: 0 0 30px 5px var(--m-col-5);
        -webkit-transition: all 0.2s ease-out;
        -moz-transition: all 0.2s ease-out;
        transition: all 0.2s ease-out;
      }

      .btn-2:hover::before {
        -webkit-animation: sh02 0.5s 0s linear;
        -moz-animation: sh02 0.5s 0s linear;
        animation: sh02 0.5s 0s linear;
      }

      .btn-2::before {
        content: '';
        display: block;
        width: 0px;
        height: 86%;
        position: absolute;
        top: 7%;
        left: 0%;
        opacity: 0;
        background: #fff;
        box-shadow: 0 0 50px 30px #fff;
        -webkit-transform: skewX(-20deg);
        -moz-transform: skewX(-20deg);
        -ms-transform: skewX(-20deg);
        -o-transform: skewX(-20deg);
        transform: skewX(-20deg);
      }

      @keyframes sh02 {
        from {
          opacity: 0;
          left: 0%;
        }

        50% {
          opacity: 1;
        }

        to {
          opacity: 0;
          left: 100%;
        }
      }

      .btn-2:active {
        box-shadow: 0 0 0 0 transparent;
        -webkit-transition: box-shadow 0.2s ease-in;
        -moz-transition: box-shadow 0.2s ease-in;
        transition: box-shadow 0.2s ease-in;
      }

      .btn-3 {
        font-size: 18px;
        letter-spacing: 2px;
        text-transform: uppercase;
        display: inline-block;
        text-align: center;
        padding: 0.7em 2em;
        border: 3px solid var(--m-col-5);
        border-radius: 2px;
        position: relative;
        box-shadow: 0 2px 10px rgba(0, 0, 0, 0.16), 0 3px 6px rgba(0, 0, 0, 0.1);
        color: var(--m-col-5);
        text-decoration: none;
        transition: 0.3s ease all;
        z-index: 1;
      }

      .btn-3:before {
        transition: 0.5s all ease;
        position: absolute;
        top: 0;
        left: 50%;
        right: 50%;
        bottom: 0;
        opacity: 0;
        content: '';
        background-color: var(--m-col-5);
        z-index: -1;
      }

      .btn-3:hover, .btn-3:focus {
        color: white;
      }

      .btn-3:hover:before, .btn-3:focus:before {
        transition: 0.5s all ease;
        left: 0;
        right: 0;
        opacity: 1;
      }

      .btn-3:active {
        transform: scale(0.9);
      }

      .btn-4 {
        display: inline-block;
        color: white;
        text-decoration: none;
        cursor: pointer;
        padding: 12px 20px;
        border-radius: 15px;
        background-color: gray;
        font-size: 25px;
        border: 2px solid black;
        transition: all 0.5s;
      }
      .btn-4:hover {
        color: white;
        background-color: var(--m-col-5);
        box-shadow: 0px 0px 15px var(--m-col-5);
        transform: scale(0.9);
      }

      .btn-5 {
        display: inline-block;
        text-decoration: none;
        border-radius: 8px;
        border: 1px solid transparent;
        padding: 0.6em 1.2em;
        font-size: 1em;
        font-weight: 400;
        font-family: inherit;
        background-color: #1a1a1a;
        cursor: pointer;
        color: white !important;
        transition: 0.2s;
      }

      .btn-5:hover {
        box-shadow: 0px 0px 17px -4px var(--m-col-5);
        border-color: var(--m-col-5);
        color: #f7f5ff;
        background-color: #2e2546;
      }

      .btn-5:active {
        box-shadow: 0px 0px 17px -7px var(--m-col-5);
        border-color: var(--m-col-5);
        transform: scale(0.95);
      }

      .main-header {
        position: relative;
        padding: 0;
        width: 100%;
        overflow-x: hidden;
      }

      .head-box {
        padding: 0;
      }

      .logo-and-menu {
        position: absolute;
        z-index: 1;
        display: flex;
        justify-content: space-between;
        padding: 26px 0;
      }

      .logo-and-name {
        display: flex;
      }

      .logo {
        height: auto;
        margin: auto 0;
        width: 50px;
      }

      .logo img {
        width: 100%;
      }

      .name {
        height: auto;
        margin: auto 0;
        color: white;
        padding-left: 12px;
        font-size: 29px;
      }

      .main-menu-list {
        text-align: center;
        display: flex;
      }

      .nav-li {
        transition: 0.5s;
        display: block;
        margin: auto 0;
        flex: 1;
        padding: 12px 30px;
        list-style: none;
        white-space: nowrap;
      }

      .nav-li:hover a {
        transition: 0.5s;
        color: var(--m-col-5);
      }

      .nav-li a, .cont a {
        text-decoration: none;
        color: white;
      }

      .burger-menu {
        display: none;
        width: 35px;
        height: 22px;
        margin: auto 10px;
      }

      .line {
        display: block;
        width: 100%;
        height: 5px;
        margin-bottom: 3px;
        background-color: black;
        border-bottom: 1px solid #333;
        border-radius: 5px;
      }

      .burgMain {
        cursor: pointer;
        display: block;
        width: 35px;
        height: 22px;
        margin: auto 10px;
      }

      .burgMain .line {
        background-color: white;
      }

      .headSlid {
        display: none;
        right: 0;
        z-index: 2;
        position: fixed;
        width: 400px;
        height: 100vh;
        background-color: black;
      }

      .cross {
        cursor: pointer;
        position: absolute;
        right: 0;
        margin: 15px 25px;
      }

      .cross svg {
        width: 30px;
        height: 30px;
        color: grey;
      }

      .headSlid .foot-logo {
        padding: 38px 25px 30px;
      }

      .cont-head {
        display: flex;
        padding: 30px 30px 0;
      }

      .cont-head svg {
        display: block;
        margin-right: 10px;
        width: 30px;
        height: 30px;
        color: var(--m-col-5);
      }

      .cont-head p {
        flex: 1;
        color: white;
        margin-bottom: 0rem;
      }

      .cont-head a {
        text-decoration: none;
        color: white;
      }

      #hedMenuTwo {
        width: 100%;
        display: none;
        position: relative;
        top: 0;
        left: 0;
        background-color: #ffffff;
      }

      #hedMenuTwo nav {
        border: 2px solid #ffffff;
      }

      #hedMenuTwo nav a {
        text-decoration: none;
        color: black;
      }

      .nav-li1 {
        padding: 15px;
        list-style: none;
        transition: 0.5s;
        border-bottom: 1px solid #333;
      }

      .nav-li1-1 {
        padding: 15px;
        list-style: none;
      }

      .content-head {
        margin: auto;
        width: 100%;
        box-sizing: border-box;
        height: auto;
      }

      .single-item-block1 {
        height: auto;
        object-fit: cover;
        background-image: linear-gradient(rgba(0, 0, 0, 0.7), rgba(0, 0, 0, 0.7)), url(graphics/hero-bg_1920x10800.webp);
        background-position: center;
        background-size: cover;
      }

      

      .hero-box {
        display: flex;
        padding: 156px 0;
        flex-direction: row-reverse;
      }

      .img-head, .title-head {
        flex: 1;
      }

      .title-head {
        height: auto;
        margin: auto 0;
        color: white;
        padding: 0 30px;
      }

      .title-head h1 {
        padding: 30px 0;
        font-size: 36px;
      }

      .img-head {
          height: auto;
          margin: auto;
      }

      .img-head img {
        border-radius: 50px 10px;
        display: block;
        width: 60%;
        margin: 0 auto;
      }

      .main-cont {
        padding: 0;
        width: 100%;
        overflow-x: hidden;
      }

      .block-benefit {
        display: flex;
        padding-top: 112px;
        flex-direction: row-reverse;
      }

      .block1 {
        flex-direction: column;
        margin: 30px 41px;
        border-radius: 5px;
        padding: 30px 30px;
        display: flex;
        background-color: #00000006;
      }

      .icon1 {
        transition: 0.5s;
        border-radius: 50%;
        width: 80px;
        height: 80px;
        background-color: var(--m-col-5);
        margin: 30px auto 30px;
      }

      .icon1 svg {
        transition: 0.5s;
        position: relative;
        top: 50%;
        left: 50%;
        width: 50%;
        height: auto;
        transform: translate(-50%,-50%);
      }

      .block1-text {
        text-align: center;
      }

      .block1-text p {
        margin-bottom: 0rem;
      }
      .benef-box {
        width: 70%;
      }
      .benef-img {
        width: 30%;
      }

      .benef-img {
        height: auto;
        margin: auto;
      }

      .benef-img img {
        width: 100%;
        display: block;
        height: 400px;
        object-fit: contain;
      }

      .block1:hover .icon1 {
        background-color: black;
        transition: 0.5s;
      }

      .block1:hover .icon1 svg {
        color: white;
        transition: 0.5s;
      }

      .benef-box .btn-1, .benef-box .btn-2, .benef-box .btn-3, .benef-box.btn-4 {
        color: black;
      }

      .main-content {
        padding-top: 112px;
        display: flex;
        flex-direction: row-reverse;
      }

      .content, .img-content {
        flex: 1;
      }

      .content {
        order: 2;
        padding: 41px;
      }

      .img-content {
        order: 1;
        width: 100%;
        height: auto;
        margin: auto 0;
        display: flex;
        align-items: center;
        justify-content: center;
      }
     
      .img-content img {
        height: 294px;
        object-fit: contain;
        width: 100%;
        display: block;
        margin: 0 auto;
      }

      .price {
        display: inline-block;
        width: auto;
        padding: 12px 30px;
        margin-top: 12px;
        font-weight: 900;
        font-size: 26px;
        border-radius: 5px;
        background-color: var(--m-col-5);
      }

      .worker {
        display: flex;
        flex-direction: column;
        padding-top: 112px;
      }

      .box-worker {
        display: flex;
        flex-wrap: wrap;
      }

      .block2 {
        display: flex;
        flex-direction: column;
        flex: 1;
        margin: 30px;
      }

      .block2 img {
        width: 100%;
        border-radius: 50px 10px;
        filter: grayscale(100%);
        transition: 0.5s;
      }

      .block2 p {
        padding: 15px 0;
        margin-bottom: 0rem;
      }

      .block2 h3 {
        font-weight: 900;
        transition: 0.5s;
      }

      .block2:hover img {
        filter: grayscale(0%);
        transition: 0.5s;
      }

      .block2:hover h3 {
        color: var(--m-col-5);
        transition: 0.5s;
      }

      .slider1 {
        padding: 80px 0;
        background-image: linear-gradient(rgba(0, 0, 0, 0.6), rgba(0, 0, 0, 0.6)), url(graphics/hero-bg_1920x10801.webp);
      }

      .content1 {
        margin: auto;
        padding: 30px;
        width: 100%;
        box-sizing: border-box;
      }

      .block3 {
        display: flex !important;
      }

      .block3 img {
        height: 55px;
        width: 100%;
        object-fit: contain;
        margin: auto;
      }

      .tariff {
        display: flex;
        flex-wrap: wrap;
        color: black;
        padding: 112px 0;
      }

      .tariff-block {
        transition: 0.5s;
        flex: 1;
        text-align: center;
        margin: 15px 30px;
        border: 1px solid grey;
        box-shadow: 5px 5px 18px #9b9696, -5px -5px 18px #a9a9a9;
        background-color: var(--m-col-5);
      }

      .wh-bg {
        background-color: white;
        padding: 30px 0;
        border-radius: 0 0 100px 100px;
      }

      .tariff-block .btn-1, .tariff-block .btn-2, .tariff-block .btn-3, .tariff-block .btn-4 {
        color: black;
        margin: 30px 30px;
        background-color: white;
      }

      .tariff-block .btn-5 {
        margin: 30px 30px;
      }

      .tariff-name {
        margin-bottom: 0rem;
        font-size: 29px;
      }

      .tariff-month {
        color: white;
        margin-bottom: 0rem;
        font-weight: 900;
        font-size: 30px;
        padding: 26px 12px 0;
      }

      .tarif1 {
        color: white;
        border-bottom: 2px solid white;
        margin-bottom: 0rem;
        padding: 26px 12px;
      }

      .tarif1 svg {
        width: 20px;
        padding-top: 3px;
        float: left;
        margin: auto 12px auto 0;
        height: 100%;
      }

      .tarif1 p {
        margin-bottom: 0rem;
      }

      .block-gallery {
        display: flex;
      }

      .title-gallery {
        padding-bottom: 30px;
        text-align: left;
      }

      .title-gallery h2 {
        font-weight: 400;
      }

      .block4 {
        margin-bottom: 30px;
        transition: 0.3s;
      }

      .block4 img {
        width: 100%;
        height: 100%;
        border-radius: 4px;
      }

      .block4:hover {
        transition: 0.3s;
        transform: scale(1.05);
      }

      .block4:hover img {
        box-shadow: 5px 5px 18px black, -5px -5px 18px black;
      }

      .comment {
        display: flex;
        padding: 41px 0;
        flex-direction: row-reverse;
      }

      .img-comment {
        flex: 1;
      }

      .img-comment img {
        object-fit: cover;
        width:100%;
        display: block;
        height: 450px;
      }

      .text-comment {
        display: flex;
        flex-direction: column;
      }

      .content2 {
        margin: auto;
        padding: 30px;
        width: 100%;
        max-width: 600px;
        box-sizing: border-box;
      }

      .main-comment {
        font-size: 19px;
      }

      .title-comment h2 {
        padding-bottom: 30px;
      }

      .block5 {
        display: flex;
        flex-direction: column;
        padding: 30px;
        border-radius: 4px;
        background-color: #00000006;
      }

      .img-and-name {
        display: flex;
      }

      .bl {
        width: 100px;
      }

      .bl img {
        width: 100%;
        border-radius: 50%;
      }

      .bl2 {
        height: auto;
        margin: auto 30px;
      }

      .bl2 h4 {
        font-weight: 900;
        color: var(--m-col-5);
      }

      .box {
        margin-top: 112px;
        background-image: linear-gradient(rgba(0, 0, 0, 0.6), rgba(0, 0, 0, 0.6)), url(graphics/hero-bg_1920x10802.webp);
      }

      .main-form {
        display: flex;
        padding: 41px 0;
        flex-direction: row-reverse;
      }

      .video-and-stats, .forma {
        flex: 1;
      }

      .video-and-stats {
        display: flex;
        flex-direction: column;
        padding: 38px 60px;
      }

      .video-player {
        width: 100%;
        border-radius: 4px;
      }

      .main-stats {
        display: flex;
        padding-top: 100px;
        color: white;
      }

      .main-stats p {
        text-align: center;
      }

      .num {
        font-weight: 900;
        font-size: 29px;
      }

      .forma {
        padding: 30px 41px;
         background-color: #afabab;;
        border-radius: 4px;
      }

      .form-title {
        padding: 38px 0;
      }

      .form-title h2 {
        color: black;
        font-weight: 400;
        padding: 0;
      }

      .input-useritem_component {
              border-radius: 22px;
              border: 0.5px solid #bbb;
              margin-bottom: 15px !important;
              padding: 12px 30px;
            }

            input::placeholder {
              color: black;
            }

            .textarea-useritem_component {
              min-height: 150px;
              border-radius: 22px;
              border: 0.5px solid #bbb;
              padding: 12px 30px;
            }

            textarea::placeholder {
              color: black;
            }

            label {
              color: black;
            }

            .form-check {
              display: flex;
              padding: 20px;
            }

            .form-check label {
              display: block;
              text-align: center;
              padding: 0 12px;
            }

            .form-check a {
              color: black;
            }

            #check-inp {
              width: auto;
              margin: 0;
            }

            .block-form input, textarea {
              margin: 0 auto;
              width: 100%;
            }

      .block-form button {
        color: black;
      }

      .main-foot {
        padding: 41px 0;
        display: flex;
        flex-direction: column;
        background-color: black;
        width: 100%;
        overflow-x: hidden;
      }

      .map {
        padding: 0;
      }

      .cont-foot {
        display: flex;
        padding: 30px 41px;
        background-color: white;
        border-radius: 4px;
      }

      .cont-foot-title {
        height: auto;
        margin: auto 0;
      }

      .cont-foot-title h2 {
        font-weight: 900;
        padding: 0;
        color: var(--m-col-5);
      }

      .cont-foot-title p {
        text-align: center;
      }

      .block7 {
        flex: 1;
        height: auto;
        margin: auto 41px;
      }

      .block7 svg {
        width: 50px;
        height: 50px;
        margin-bottom: 15px;
        color: var(--m-col-5);
      }

      .block7 a {
        text-decoration: none;
        color: black;
      }

      .logo-and-news {
        display: flex;
        flex-direction: row-reverse;
        padding-top: 100px;
        padding-bottom: 41px;
      }

      .foot-logo {
        flex: 1;
        color: white;
      }

      .foot-logo p {
        padding-top: 30px;
        margin-bottom: 0rem;
      }

      .foot-menu {
        flex: 1;
      }

      .foot-menu h2 {
        text-align: center;
        color: white;
        padding: 0;
        font-weight: 400;
      }

      .foot-menu nav {
        flex-direction: column;
      }

      .foot-cont h2 {
        color: white;
        padding-bottom: 12px;
        font-weight: 400;
      }

      .newsletter {
        flex: 1;
        height: 100%;
        padding-bottom: 30px;
        color: white;
      }

      .newsletter h4 {
        padding: 0 0 30px;
      }

      .newsletter .input-useritem_component {
        width: 100%;
      }

      .newsletter button {
        margin-top: 30px;
      }

      .footPrivBlok {
        border-top: 1px solid;
        display: flex;
        flex-wrap: wrap;
        justify-content: space-between;
        padding: 30px 0 15px;
      }

      .footPrivBlok a {
        text-decoration: none;
        color: white;
      }

      .empty {
        height: 2px;
        width: 50px;
        margin-bottom: 15px;
        background-color: var(--m-col-5);
      }
      .single-item2 {
        direction: initial;
      }

      @media (max-width: 1200px) {

        .text-comment {
          width: 500px;
        }

      }

      @media (max-width: 991px) {
        .benef-img {
          width: 100%;
        }
        .benef-box {
          width: 100%;
        }
        .head-box {
          background-color: var(--m-col-5);
        }

        .logo-and-menu {
          position: relative;
        }

        .main-menu {
          display: none;
        }

        .burger-menu {
          display: block;
        }

        .burgMain {
          display: none;
        }

        .block-benefit {
          flex-direction: column;
        }

        .benef-img {
          margin: 30px auto;
        }

        .benef-img img {
          width: 100%;
        }

        .main-content {
          flex-direction: column;
        }

        .block2 {
          flex: none;
          margin: 20px 0;
          padding: 10px;
        }

        .tariff {
          flex-direction: column;
        }

        .comment {
          flex-direction: column;
        }

        .text-comment {
          width: 100%;
          margin-top: 41px;
        }

        .main-form {
          flex-direction: column;
        }

        .block7 {
          margin: auto 15px;
        }

        .logo-and-news {
          flex-direction: column;
        }

        .foot-logo {
          width: auto;
          margin: 0 auto;
          margin-bottom: 38px;
          text-align: center;
        }

        .newsletter {
          margin-top: 38px;
          text-align: center;
        }

      }

      @media(max-width: 767px) {

        .hero-box {
          flex-direction: column;
        }

        .img-head {
          order: 1;
          margin: 0 auto 41px;
        }

        .title-head {
          order: 2;
          text-align: center;
        }

        .title-head h1 {
          font-size: 26px;
        }

        .cont-foot {
          flex-direction: column;
        }

        .cont-foot-title {
          width: 100%;
          margin: 0 auto;
        }

        .block7 {
          width: auto;
          margin: 20px auto;
          text-align: center;
        }

        .footPrivBlok {
          flex-direction: column;
        }

        .footPrivBlok a {
          text-align: center;
        }

      }

      @media(max-width: 575px) {
        .img-content img {
          height: auto;
        }

        .title-head h1 {
          font-size: 26px;
        }

        .block1 {
          margin: 20px 5px;
        }

        .img-content {
          width: 100%;
          padding: 0 0 30px;
        }

        .content {
          padding: 10px;
        }

        .content2 {
          padding: 10px;
        }

        .video-and-stats {
          padding: 38px 10px;
        }

        .forma {
          padding: 30px 10px;
        }

        .cont-foot {
          padding: 30px 20px;
        }

        .foot-logo .name {
          font-size: 19px;
        }
      }
    </style>

    
  </head>

  <body>

    

    <header class="container-fluid main-header">
      <div class="container-fluid head-box">
        <div class="headSlid">
          <div class="cross">
            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-x-square" viewBox="0 0 16 16">
              <path d="M14 1a1 1 0 0 1 1 1v12a1 1 0 0 1-1 1H2a1 1 0 0 1-1-1V2a1 1 0 0 1 1-1zM2 0a2 2 0 0 0-2 2v12a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V2a2 2 0 0 0-2-2z"/>
              <path d="M4.646 4.646a.5.5 0 0 1 .708 0L8 7.293l2.646-2.647a.5.5 0 0 1 .708.708L8.707 8l2.647 2.646a.5.5 0 0 1-.708.708L8 8.707l-2.646 2.647a.5.5 0 0 1-.708-.708L7.293 8 4.646 5.354a.5.5 0 0 1 0-.708"/>
            </svg>
          </div>
          <div class="foot-logo">
            <div class="logo-and-name">
              <div class="logo">
                <img src="logo-black.png" alt="" />
              </div>
              <div class="name">Glamorixlots</div>
            </div>
            <p>Chez Glamorixlots, nous croyons que la beauté est un voyage quotidien qui mérite d'être célébré avec élégance et qualité. Notre mission est de vous offrir des calendriers de beauté exclusifs, remplis de produits haut de gamme issus des meilleures marques mondiales. Chaque calendrier est une invitation à découvrir de nouvelles sensations et à prendre soin de soi avec des soins adaptés, du maquillage raffiné et des fragrances envoûtantes. Que ce soit pour vous faire plaisir ou pour offrir un cadeau exceptionnel, Glamorixlots vous accompagne dans chaque moment de votre routine beauté, en apportant luxe, surprise et satisfaction. Nous sélectionnons rigoureusement chaque produit pour garantir une expérience inoubliable et un engagement envers la qualité et l'authenticité. Rejoignez notre communauté de passionnés et transformez chaque jour en une célébration de votre beauté unique.</p>
          </div>

           <div class="cont-head">
            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-geo-alt" viewBox="0 0 16 16">
              <path d="M12.166 8.94c-.524 1.062-1.234 2.12-1.96 3.07A32 32 0 0 1 8 14.58a32 32 0 0 1-2.206-2.57c-.726-.95-1.436-2.008-1.96-3.07C3.304 7.867 3 6.862 3 6a5 5 0 0 1 10 0c0 .862-.305 1.867-.834 2.94M8 16s6-5.686 6-10A6 6 0 0 0 2 6c0 4.314 6 10 6 10"/>
              <path d="M8 8a2 2 0 1 1 0-4 2 2 0 0 1 0 4m0 1a3 3 0 1 0 0-6 3 3 0 0 0 0 6"/>
            </svg>
            <p> 74, rue Descartes 67200 STRASBOURG</p>
          </div>

          <div class="cont-head">
            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-envelope" viewBox="0 0 16 16">
              <path d="M0 4a2 2 0 0 1 2-2h12a2 2 0 0 1 2 2v8a2 2 0 0 1-2 2H2a2 2 0 0 1-2-2zm2-1a1 1 0 0 0-1 1v.217l7 4.2 7-4.2V4a1 1 0 0 0-1-1zm13 2.383-4.708 2.825L15 11.105zm-.034 6.876-5.64-3.471L8 9.583l-1.326-.795-5.64 3.47A1 1 0 0 0 2 13h12a1 1 0 0 0 .966-.741M1 11.105l4.708-2.897L1 5.383z"/>
            </svg>
            <a href="mailto:getfrancegift@gmail.com" class="a-email">getfrancegift@gmail.com</a>
          </div>

          <div class="cont-head">
            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-telephone" viewBox="0 0 16 16">
              <path d="M3.654 1.328a.678.678 0 0 0-1.015-.063L1.605 2.3c-.483.484-.661 1.169-.45 1.77a17.6 17.6 0 0 0 4.168 6.608 17.6 17.6 0 0 0 6.608 4.168c.601.211 1.286.033 1.77-.45l1.034-1.034a.678.678 0 0 0-.063-1.015l-2.307-1.794a.68.68 0 0 0-.58-.122l-2.19.547a1.75 1.75 0 0 1-1.657-.459L5.482 8.062a1.75 1.75 0 0 1-.46-1.657l.548-2.19a.68.68 0 0 0-.122-.58zM1.884.511a1.745 1.745 0 0 1 2.612.163L6.29 2.98c.329.423.445.974.315 1.494l-.547 2.19a.68.68 0 0 0 .178.643l2.457 2.457a.68.68 0 0 0 .644.178l2.189-.547a1.75 1.75 0 0 1 1.494.315l2.306 1.794c.829.645.905 1.87.163 2.611l-1.034 1.034c-.74.74-1.846 1.065-2.877.702a18.6 18.6 0 0 1-7.01-4.42 18.6 18.6 0 0 1-4.42-7.009c-.362-1.03-.037-2.137.703-2.877z"/>
            </svg>
            <a href="tel:+33745718646" class="a-phone">+33745718646</a>
          </div> 
        </div>
        <div class="container">
          <div class="container logo-and-menu">
            <div class="logo-and-name">
              <div class="logo">
                <img src="logo-black.png" alt="" />
              </div>
              <div class="name">Glamorixlots</div>
            </div>

            <div class="main-menu">
              <nav class="main-menu-list">
                <li class="nav-li">
                  <a href="./#home" class="menu-a">Domicile</a>
                </li>
                <li class="nav-li">
                  <a href="./#benefit" class="menu-a">Nos avantages</a>
                </li>
                
                <li class="nav-li">
                  <a href="./#worker" class="menu-a">Notre équipe</a>
                </li>
                 
                <li class="nav-li">
                  <a href="./#comment" class="menu-a">Commentaires</a>
                </li>
                
              </nav>
            </div>
            <div class="burger-menu">
              <div class="func" onmousedown="openBurg()">
                <span class="line"></span>
                <span class="line"></span>
                <span class="line"></span>
              </div>
            </div>
            <div class="burgMain">
              <span class="line"></span>
              <span class="line"></span>
              <span class="line"></span>
            </div>
          </div>
        </div>
      </div>
      <div id="hedMenuTwo">
        <nav class="container">
          <a href="./#home" class="menu-a"><li class="nav-li1">Domicile</li></a>
          <a href="./#benefit" class="menu-a"><li class="nav-li1">Nos avantages</li></a>
          
          <a href="./#worker" class="menu-a"><li class="nav-li1">Notre équipe</li></a>
           
          <a href="./#comment" class="menu-a"><li class="nav-li1-1">Commentaires</li></a>
          
        </nav>
      </div>

      <div class="content-head">
        <div class="slider single-item" style="direction: initial;">
          <div class="single-item-block1">
            <div class="container hero-box">
              <div class="img-head">
                <img src="graphics/gallery_2025-09-26_15-310.webp" alt="" />
              </div>
              <div class="title-head">
                <h1>Bienvenue chez Glamorixlots, votre destination ultime pour découvrir la joie de la beauté chaque jour. Plongez dans un univers de luxe et de soins exclusifs avec nos calendriers de beauté soigneusement sélectionnés, conçus pour sublimer votre routine quotidienne de soins, maquillage et parfums. Offrez-vous ou offrez à un être cher une expérience unique où chaque jour devient une célébration du bien-être et du style.</h1>
                
              </div>
            </div>
          </div>
        </div>
      </div>
    </header>
    

    <a name="benefit"></a>
    <main class="container-fluid main-cont">
      <div class="container block-benefit txtrs--link">
        <div class="benef-box">
          <h2>Nos avantages</h2>
          <div class="block1">
            <div class="icon1">
              <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-pc-display" viewBox="0 0 16 16">
                <path d="M8 1a1 1 0 0 1 1-1h6a1 1 0 0 1 1 1v14a1 1 0 0 1-1 1H9a1 1 0 0 1-1-1zm1 13.5a.5.5 0 1 0 1 0 .5.5 0 0 0-1 0m2 0a.5.5 0 1 0 1 0 .5.5 0 0 0-1 0M9.5 1a.5.5 0 0 0 0 1h5a.5.5 0 0 0 0-1zM9 3.5a.5.5 0 0 0 .5.5h5a.5.5 0 0 0 0-1h-5a.5.5 0 0 0-.5.5M1.5 2A1.5 1.5 0 0 0 0 3.5v7A1.5 1.5 0 0 0 1.5 12H6v2h-.5a.5.5 0 0 0 0 1H7v-4H1.5a.5.5 0 0 1-.5-.5v-7a.5.5 0 0 1 .5-.5H7V2z"/>
              </svg>
            </div>
            <div class="block1-text">
              <p>Sélection exclusive Nos calendriers contiennent uniquement des produits de marques prestigieuses, garantissant qualité et efficacité.</p>
            </div>
          </div>
          <div class="block1">
            <div class="icon1">
              <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-telephone-inbound-fill" viewBox="0 0 16 16">
                <path fill-rule="evenodd" d="M1.885.511a1.745 1.745 0 0 1 2.61.163L6.29 2.98c.329.423.445.974.315 1.494l-.547 2.19a.68.68 0 0 0 .178.643l2.457 2.457a.68.68 0 0 0 .644.178l2.189-.547a1.75 1.75 0 0 1 1.494.315l2.306 1.794c.829.645.905 1.87.163 2.611l-1.034 1.034c-.74.74-1.846 1.065-2.877.702a18.6 18.6 0 0 1-7.01-4.42 18.6 18.6 0 0 1-4.42-7.009c-.362-1.03-.037-2.137.703-2.877zM15.854.146a.5.5 0 0 1 0 .708L11.707 5H14.5a.5.5 0 0 1 0 1h-4a.5.5 0 0 1-.5-.5v-4a.5.5 0 0 1 1 0v2.793L15.146.146a.5.5 0 0 1 .708 0"/>
              </svg>
            </div>
            <div class="block1-text">
              <p>Surprises quotidiennes Chaque jour, découvrez un nouveau produit qui ravira vos sens et enrichira votre routine beauté.</p>
            </div>
          </div>
          <div class="block1">
            <div class="icon1">
              <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-journal-check" viewBox="0 0 16 16">
                <path fill-rule="evenodd" d="M10.854 6.146a.5.5 0 0 1 0 .708l-3 3a.5.5 0 0 1-.708 0l-1.5-1.5a.5.5 0 1 1 .708-.708L7.5 8.793l2.646-2.647a.5.5 0 0 1 .708 0"/>
                <path d="M3 0h10a2 2 0 0 1 2 2v12a2 2 0 0 1-2 2H3a2 2 0 0 1-2-2v-1h1v1a1 1 0 0 0 1 1h10a1 1 0 0 0 1-1V2a1 1 0 0 0-1-1H3a1 1 0 0 0-1 1v1H1V2a2 2 0 0 1 2-2"/>
                <path d="M1 5v-.5a.5.5 0 0 1 1 0V5h.5a.5.5 0 0 1 0 1h-2a.5.5 0 0 1 0-1zm0 3v-.5a.5.5 0 0 1 1 0V8h.5a.5.5 0 0 1 0 1h-2a.5.5 0 0 1 0-1zm0 3v-.5a.5.5 0 0 1 1 0v.5h.5a.5.5 0 0 1 0 1h-2a.5.5 0 0 1 0-1z"/>
              </svg>
            </div>
            <div class="block1-text">
              <p>Cadeau parfait Un présent idéal pour soi ou pour offrir, alliant luxe, raffinement et personnalisation.</p>
            </div>
          </div>
          <div class="block1">
            <div class="icon1">
              <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-gear-wide-connected" viewBox="0 0 16 16">
                <path d="M7.068.727c.243-.97 1.62-.97 1.864 0l.071.286a.96.96 0 0 0 1.622.434l.205-.211c.695-.719 1.888-.03 1.613.931l-.08.284a.96.96 0 0 0 1.187 1.187l.283-.081c.96-.275 1.65.918.931 1.613l-.211.205a.96.96 0 0 0 .434 1.622l.286.071c.97.243.97 1.62 0 1.864l-.286.071a.96.96 0 0 0-.434 1.622l.211.205c.719.695.03 1.888-.931 1.613l-.284-.08a.96.96 0 0 0-1.187 1.187l.081.283c.275.96-.918 1.65-1.613.931l-.205-.211a.96.96 0 0 0-1.622.434l-.071.286c-.243.97-1.62.97-1.864 0l-.071-.286a.96.96 0 0 0-1.622-.434l-.205.211c-.695.719-1.888.03-1.613-.931l.08-.284a.96.96 0 0 0-1.186-1.187l-.284.081c-.96.275-1.65-.918-.931-1.613l.211-.205a.96.96 0 0 0-.434-1.622l-.286-.071c-.97-.243-.97-1.62 0-1.864l.286-.071a.96.96 0 0 0 .434-1.622l-.211-.205c-.719-.695-.03-1.888.931-1.613l.284.08a.96.96 0 0 0 1.187-1.186l-.081-.284c-.275-.96.918-1.65 1.613-.931l.205.211a.96.96 0 0 0 1.622-.434zM12.973 8.5H8.25l-2.834 3.779A4.998 4.998 0 0 0 12.973 8.5m0-1a4.998 4.998 0 0 0-7.557-3.779l2.834 3.78zM5.048 3.967l-.087.065zm-.431.355A4.98 4.98 0 0 0 3.002 8c0 1.455.622 2.765 1.615 3.678L7.375 8zm.344 7.646.087.065z"/>
              </svg>
            </div>
            <div class="block1-text">
              <p>Engagement qualité Nous veillons à la satisfaction de nos clients avec une sélection rigoureuse et un service client attentif.</p>
            </div>
          </div>
          <div style="display: flex; justify-content: center">
            
          </div>
        </div>
        <div class="benef-img">
          <img src="graphics/illustration_854x4800.png" alt="" />
        </div>
      </div>

      <div class="container main-content checkoutno-column">
        <div class="content">
          <h2>Déballez le luxe et la joie au quotidien avec  Glamorixlots  Beauté</h2>
          <p><p>À  Glamorixlots  , nous pensons que la beauté doit être plus qu'une routine : elle doit être un rituel, rempli d'anticipation, de plaisir et d'une touche de luxe. C'est pourquoi nous avons créé nos calendriers beauté exclusifs, chacun étant une expérience organisée conçue pour apporter un peu d'éclat à chaque jour.</p>
<p>Chaque tiroir, chaque boîte, chaque moment de découverte est une célébration du soin personnel, de la confiance et de l'élégance intemporelle. Que vous souhaitiez vous faire plaisir ou surprendre quelqu'un de spécial, nos calendriers transforment les journées ordinaires en une symphonie de parfums, de couleurs et d'éclat.</p>
<p style="text-align: center;"> <strong>Un cadeau qui continue à offrir</strong> </p>
<p>Pourquoi ouvrir un seul cadeau quand on peut vivre chaque jour un nouveau moment de beauté ? <br>Nos calendriers beauté sont des collections soigneusement conçues qui combinent le meilleur des soins de la peau, du maquillage et des parfums. Chaque produit est sélectionné avec soin auprès des plus grandes marques mondiales, garantissant que chaque jour révèle quelque chose d'extraordinaire&nbsp;: un sérum qui brille, un rouge à lèvres qui donne du pouvoir, un parfum qui persiste.</p>
<p>Considérez-le comme un voyage à travers le monde de la beauté luxueuse, qui se déroule jour après jour – une délicieuse évasion de l’ordinaire.</p>
<p style="text-align: center;"> <strong>Qu'y a-t-il à l'intérieur du  Glamorixlots  Calendriers beauté</strong> </p>
<p>Chaque  Glamorixlots  le calendrier est un chef-d’œuvre de conception et de conservation.&nbsp;A l’intérieur, vous découvrirez :</p>
<ul>
<li> <strong>Essentiels de soins de la peau haut de gamme</strong> – offrez-vous des sérums, crèmes et masques qui redonnent à votre peau son éclat naturel.</li>
<li> <strong>Icônes de maquillage de luxe</strong> – dévoilez des rouges à lèvres audacieux, des surligneurs lumineux et des ombres soyeuses de marques renommées.</li>
<li> <strong>Délices parfumés</strong> – découvrez des parfums miniatures et des trésors aromatiques qui capturent l’essence de la sophistication.</li>
<li> <strong>Surprises exclusives</strong> – des articles en édition limitée et des joyaux cachés choisis pour inspirer joie et confiance.</li>
</ul>
<p>Chaque produit est plus qu’un simple régal : c’est un moment de connexion avec votre éclat intérieur.</p>
<p style="text-align: center;"> <strong>L'art de donner, redéfini</strong> </p>
<p>À la recherche du <em>cadeau parfait</em> ? <br>UN  Glamorixlots  Le Calendrier Beauté n’est pas seulement un cadeau comme les autres : c’est un voyage d’indulgence d’un mois, enveloppé d’anticipation et de grâce. Des anniversaires aux fêtes de fin d’année et au-delà, c’est le moyen idéal d’exprimer son attention, son admiration et sa prévenance.</p>
<p>Imaginez la joie de voir un être cher révéler chaque matin un nouveau secret de beauté – un rituel de découverte qui commence par l’émerveillement et se termine dans la confiance.</p>
<p>Chaque déballage devient un murmure de luxe. Chaque jour devient une fête.</p>
<p style="text-align: center;"> <strong>Pour chaque style, chaque envie</strong> </p>
<p>Nos calendriers sont soigneusement conçus pour tous les amoureux de la beauté, des amateurs de soins de la peau aux amateurs de maquillage. <br>Choisissez parmi plusieurs collections, chacune avec son propre thème et son propre ambiance. Que vous adoriez l'élégance minimale ou le glamour audacieux,  Glamorixlots  propose un calendrier qui correspond à votre philosophie personnelle d’esthétique et de beauté.</p>
<p>Chaque calendrier est joliment emballé, fabriqué avec des matériaux durables et prêt à occuper une place de choix sur votre vanité.</p>
<p style="text-align: center;"> <strong>Pourquoi choisir  Glamorixlots  </strong></p>
<ul>
<li> <strong>Luxe organisé</strong> – uniquement des mini-produits premium, pleine grandeur et de luxe provenant des plus grandes maisons de beauté.</li>
<li> <strong>Délice quotidien</strong> – expérimentez chaque matin de nouvelles sensations de texture, de couleur et de parfum.</li>
<li> <strong>Élégance durable</strong> – nos calendriers sont conçus avec des matériaux respectueux de l’environnement et un savoir-faire raffiné.</li>
<li> <strong>Disponibilité limitée</strong> – fabriqué en petits lots pour garantir l’exclusivité et une valeur intemporelle.</li>
</ul>
<p>À  Glamorixlots  , nous ne vendons pas seulement de la beauté - nous <em>célébrez-le</em> .</p>
<p style="text-align: center;"> <strong>Déballez votre moment de magie</strong> </p>
<p>Entrez dans un monde où chaque journée commence par la beauté et se termine par la confiance.&nbsp;Notre  Glamorixlots  Les calendriers beauté sont plus que de simples cadeaux : ce sont des expériences qui inspirent l’amour-propre et élèvent vos moments quotidiens en quelque chose de vraiment extraordinaire.</p></p>
           
        </div>
        <div class="img-content">
          <img src="service-images/reality-beauty-cosmetics-2025-10-09-1.jpg" alt="Déballez le luxe et la joie au quotidien avec  Glamorixlots  Beauté" />
        </div>
      </div>
      <div class="container-fluid slider1">
        <div class="container content1">
          <div class="slider autoplay" style="direction: initial;">
            <div class="block3">
              <img src="graphics/partners_2025-10-03_15-31-280.png" alt="" />
            </div>
            <div class="block3">
              <img src="graphics/partners_2025-10-03_15-31-281.png" alt="" />
            </div>
            <div class="block3">
              <img src="graphics/partners_2025-10-03_15-31-282.png" alt="" />
            </div>
            <div class="block3">
              <img src="graphics/partners_2025-10-03_15-31-283.png" alt="" />
            </div>
            <div class="block3">
              <img src="graphics/partners_2025-10-03_15-31-284.png" alt="" />
            </div>
            <div class="block3">
              <img src="graphics/partners_2025-10-03_15-31-285.png" alt="" />
            </div>
          </div>
        </div>
      </div>
     

      

      <a name="worker"></a>
      
      <div class="container worker">
        <h2>Notre équipe</h2>
        <div class="box-worker row-cols-1 row-cols-md-2">
          <div class="col block2">
            <img src="graphics/thumb_hVnd_0.webp" alt="" />
            <p>Esthéticien(ne)</p>
            <div class="empty"></div>
            <h3>Camille Durand</h3>
          </div>
          <div class="col block2">
            <img src="graphics/ava_2025-10-11_15-31-28_0.webp" alt="" />
            <p>Maquilleur(se)</p>
            <div class="empty"></div>
            <h3>Lucas Martin</h3>
          </div>
          <div class="col block2">
            <img src="graphics/thumb_hVnd_1.webp" alt="" />
            <p>Dermatologue</p>
            <div class="empty"></div>
            <h3>Léa Morel</h3>
          </div>
          <div class="col block2">
            <img src="graphics/thumb_hVnd_2.webp" alt="" />
            <p>Conseiller(ère) en beauté</p>
            <div class="empty"></div>
            <h3>Manon Dupuis</h3>
          </div>
        </div>
      </div>
      
     
      <div class="container-fluid box">
        <div class="container main-form">
          <div class="video-and-stats">
            <div class="main-video">
              <video class="video-player" autoplay="" muted="muted" loop="" playsinline="" controlslist="nodownload" controls>
                <source src="graphics/hero_1600x9000.mp4" type="video/mp4" />
              </video>
            </div>
            <div class="main-stats row row-cols-lg-2 row-cols-md-2 row-cols-sm-2 row-cols-2">
              <div class="col block6">
                <p class="num">57990</p>
                <p>Agents professionnels</p>
              </div>
              <div class="col block6">
                <p class="num">66755</p>
                <p>Projets menés à bien</p>
              </div>
              <div class="col block6">
                <p class="num">27614</p>
                <p>Appels téléphoniques</p>
              </div>
              <div class="col block6">
                <p class="num">12894</p>
                <p>Demandes exécutées</p>
              </div>
            </div>
          </div>
          
          <div class="forma" id="transition-form">
            <div class="form-title">
              <h2>Bon de commande</h2>
            </div>
            <div>
               <form method="post" class="block-form" action="acknowledgement.php">
                <input class="input-useritem_component" type="text" name="namesecondary-entry" placeholder="Entrez votre nom" required><input name="phonesecondary-entry" class="input-useritem_component" type="tel" placeholder="Entrez votre numéro de téléphone" required><input name="emailsecondary-entry" class="input-useritem_component" type="email" placeholder="Adresse courriel" required>
                <div class="form-check">
                  <input type="checkbox" id="check-inp" required />
                  <label for="check-inp">
                    J’accepte <a href="privacy.html">Politique de confidentialité</a>
                  </label>
                </div>
                <button  type="submit" class="btn-5">
                  Consultation d’experts
                </button>
              </form>
            </div>
          </div>
          
        </div>
      </div>

      <a name="comment"></a>
      
      <div class="container comment accountqr--element">
        <div class="img-comment">
          <img src="graphics/gallery_2025-09-26_15-311.webp" alt="" />
        </div>
        <div class="text-comment">
          <div class="title-comment">
            <h2>Commentaires</h2>
          </div>
          <div class="slider-comment">
            <div class="content2">
              <div class="slider single-item2" >
                <div class="block5">
                  <div class="main-comment">
                    <p>Les calendriers Glamorixlots ont transformé ma routine quotidienne. Chaque surprise est un vrai plaisir.</p>
                  </div>
                  <div class="img-and-name">
                    <div class="bl">
                      <img src="graphics/ava_2025-10-11_15-31-28_1.webp" alt="" />
                    </div>
                    <div class="bl2">
                      <h4>Julien Dubois</h4>
                      <p>Parfumeur(se)</p>
                    </div>
                  </div>
                </div>
                <div class="block5">
                  <div class="main-comment">
                    <p>J'adore ouvrir chaque jour une nouvelle case, c'est comme un petit moment de bonheur personnel.</p>
                  </div>
                  <div class="img-and-name">
                    <div class="bl">
                      <img src="graphics/thumb_hVnd_0.webp" alt="" />
                    </div>
                    <div class="bl2">
                      <h4>Chloé Laurent</h4>
                      <p>Spécialiste en soins de la peau</p>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
      
    </main>
    
    <footer class="container-fluid main-foot">

      <div class="container foot">
         <div class="cont-foot row row-cols-lg-2 row-cols-md-2 row-cols-sm-2 row-cols-4">
          <div class="col cont-foot-title">
            <h2>Contacts</h2>
            <p>Vos commentaires sont inestimables pour nous ! Nous nous engageons à améliorer votre expérience et apprécions que vous preniez le temps de partager vos réflexions. Veuillez laisser vos commentaires, suggestions ou préoccupations dans la case ci-dessous et aidez-nous à mieux répondre à vos besoins.</p>
          </div>
          <div class="col block7">
            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-envelope" viewBox="0 0 16 16">
              <path d="M0 4a2 2 0 0 1 2-2h12a2 2 0 0 1 2 2v8a2 2 0 0 1-2 2H2a2 2 0 0 1-2-2zm2-1a1 1 0 0 0-1 1v.217l7 4.2 7-4.2V4a1 1 0 0 0-1-1zm13 2.383-4.708 2.825L15 11.105zm-.034 6.876-5.64-3.471L8 9.583l-1.326-.795-5.64 3.47A1 1 0 0 0 2 13h12a1 1 0 0 0 .966-.741M1 11.105l4.708-2.897L1 5.383z"/>
            </svg>
            <h3>Adresse postale</h3>
            <a href="mailto:getfrancegift@gmail.com" class="a-email">getfrancegift@gmail.com</a>
          </div>

          <div class="col block7">
            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-telephone" viewBox="0 0 16 16">
              <path d="M3.654 1.328a.678.678 0 0 0-1.015-.063L1.605 2.3c-.483.484-.661 1.169-.45 1.77a17.6 17.6 0 0 0 4.168 6.608 17.6 17.6 0 0 0 6.608 4.168c.601.211 1.286.033 1.77-.45l1.034-1.034a.678.678 0 0 0-.063-1.015l-2.307-1.794a.68.68 0 0 0-.58-.122l-2.19.547a1.75 1.75 0 0 1-1.657-.459L5.482 8.062a1.75 1.75 0 0 1-.46-1.657l.548-2.19a.68.68 0 0 0-.122-.58zM1.884.511a1.745 1.745 0 0 1 2.612.163L6.29 2.98c.329.423.445.974.315 1.494l-.547 2.19a.68.68 0 0 0 .178.643l2.457 2.457a.68.68 0 0 0 .644.178l2.189-.547a1.75 1.75 0 0 1 1.494.315l2.306 1.794c.829.645.905 1.87.163 2.611l-1.034 1.034c-.74.74-1.846 1.065-2.877.702a18.6 18.6 0 0 1-7.01-4.42 18.6 18.6 0 0 1-4.42-7.009c-.362-1.03-.037-2.137.703-2.877z"/>
            </svg>
            <h3>Appelle-moi</h3>
            <a href="tel:+33745718646" class="a-phone">+33745718646</a>
          </div>

          <div class="col block7">
            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-geo-alt" viewBox="0 0 16 16">
              <path d="M12.166 8.94c-.524 1.062-1.234 2.12-1.96 3.07A32 32 0 0 1 8 14.58a32 32 0 0 1-2.206-2.57c-.726-.95-1.436-2.008-1.96-3.07C3.304 7.867 3 6.862 3 6a5 5 0 0 1 10 0c0 .862-.305 1.867-.834 2.94M8 16s6-5.686 6-10A6 6 0 0 0 2 6c0 4.314 6 10 6 10"/>
              <path d="M8 8a2 2 0 1 1 0-4 2 2 0 0 1 0 4m0 1a3 3 0 1 0 0-6 3 3 0 0 0 0 6"/>
            </svg>
            <h3>Adresse Emplacement</h3>
            <p> 74, rue Descartes 67200 STRASBOURG</p>
          </div>
        </div>
        
        <div class="logo-and-news">
          <div class="foot-logo">
            <div class="logo-and-name">
              <div class="logo">
                <img src="logo-black.png" alt="" />
              </div>
              <div class="name">Glamorixlots</div>
            </div>
            <p>Chez Glamorixlots, nous croyons que la beauté est un voyage quotidien qui mérite d'être célébré avec élégance et qualité. Notre mission est de vous offrir des calendriers de beauté exclusifs, remplis de produits haut de gamme issus des meilleures marques mondiales. Chaque calendrier est une invitation à découvrir de nouvelles sensations et à prendre soin de soi avec des soins adaptés, du maquillage raffiné et des fragrances envoûtantes. Que ce soit pour vous faire plaisir ou pour offrir un cadeau exceptionnel, Glamorixlots vous accompagne dans chaque moment de votre routine beauté, en apportant luxe, surprise et satisfaction. Nous sélectionnons rigoureusement chaque produit pour garantir une expérience inoubliable et un engagement envers la qualité et l'authenticité. Rejoignez notre communauté de passionnés et transformez chaque jour en une célébration de votre beauté unique.</p>
          </div>

          <div class="foot-menu">
            <h2>Menu</h2>
            <nav class="main-menu-list">
              <li class="nav-li">
                <a href="./#home" class="menu-a">Domicile</a>
              </li>
              <li class="nav-li">
                <a href="./#benefit" class="menu-a">Nos avantages</a>
              </li>
              
              <li class="nav-li">
                <a href="./#worker" class="menu-a">Notre équipe</a>
              </li>
               
              <li class="nav-li">
                <a href="./#comment" class="menu-a">Commentaires</a>
              </li>
              
            </nav>
          </div>

          <div class="newsletter">
            <h4>Newsletter 10% de réduction</h4>
             <form method="post" action="subscriptions.php">
              <input type="email" class="input-useritem_component" placeholder="Adresse postale" required/>
              <button  type="submit" class="btn-5">
                Je veux m’abonner
              </button>
            </form>
          </div>
        </div>
        <div class="container footPrivBlok">
          <a href="privacy.html">Politique de confidentialité</a>
          <a href="terms.html">Termes et conditions</a>
          <a href="legal-disclaimer.html">Démenti</a>
        </div>
      </div>
    </footer>

    <script>
      let clickCount = 0;

      function openBurg() {
        clickCount++;

        if (clickCount % 2 === 0) {
          document.getElementById('hedMenuTwo').style.display = 'none';
        } else {
          document.getElementById('hedMenuTwo').style.display = 'block';
        }
      }

      window.addEventListener('resize', function () {
        document.getElementById('hedMenuTwo').style.display = 'none';

        clickCount = 0;
      });
    </script>

    
    <script>
        document.querySelector('.burgMain').addEventListener('click', function () {
          document.querySelector('.headSlid').style.display = 'block';
          document.querySelector('.headSlid').style.transition = 'opacity 0.8s';
          document.querySelector('.headSlid').style.opacity = '1';
      });

      document.querySelector('.cross').addEventListener('click', function () {
          let sidebar = document.querySelector('.headSlid');
          sidebar.style.transition = 'opacity 0.8s';
          sidebar.style.opacity = '0';
          setTimeout(() => {
              sidebar.style.display = 'none';
          }, 800);
      });
    </script>

     
    
    <script>

      $('.single-item').slick({
        speed: 800,
        autoplay: true,
        autoplaySpeed: 3000,
      });
      
      $('.autoplay').slick({
        dots: false,
        infinite: true,
        speed: 500,
        slidesToShow: 5,
        slidesToScroll: 1,
        autoplay: true,
        autoplaySpeed: 1000,
        responsive: [
          {
            breakpoint: 1300,
            settings: {
              slidesToShow: 4,
              slidesToScroll: 1,
              infinite: true,
              dots: false,
            },
          },
          {
            breakpoint: 991,
            settings: {
              slidesToShow: 3,
              slidesToScroll: 1,
              infinite: true,
              dots: false,
            },
          },
          {
            breakpoint: 767,
            settings: {
              slidesToShow: 2,
              slidesToScroll: 1,
            },
          },
          {
            breakpoint: 575,
            settings: {
              slidesToShow: 1,
              slidesToScroll: 1,
            },
          },
        ],
      });
      
      $('.single-item2').slick({
        dots: true,
        infinite: true,
        speed: 500,
        autoplay: true,
        slidesToShow: 1,
        slidesToScroll: 1,
      });
    </script>

    

  </body>
</html>

